const express = require('express');
const app = express("app");
var path = require('path');

app.set('view engine', 'ejs');
app.use(express.static('public'));
app.use(express.urlencoded({ extended: true }));
var bodyParser = require('body-parser');
const { name } = require('ejs');


app.get('/', (req, res) => {
    res.render('index', { items });
});

let items = [
    { id: '1', name: 'Milk', quantity: '2' },
    { id: '2', name: 'Bread', quantity: '1' },
    { id: '3', name: 'Eggs', quantity: '12' }
];
let nextId = 4;

function validateItem(name, quantity) {
  const errors = {};
  const cleanName = (name ?? "").trim();

  if (!cleanName) errors.name = "Please enter an item name.";
  else if (cleanName.length < 2) errors.name = "Item name must be 2+ characters.";

  const qtyNum = Number(quantity);
  if (quantity === undefined || quantity === null || String(quantity).trim() === "") {
    errors.quantity = "Please enter a quantity.";
  } else if (!Number.isInteger(qtyNum) || qtyNum <= 0) {
    errors.quantity = "Quantity must be a whole number (1 or more).";
  }

  return { isValid: Object.keys(errors).length === 0, errors, cleanName, qtyNum };
}

function getItemById(id) {
  return items.find((x) => x.id === id);
}

app.get("/", (req, res) => {
  res.render("index", {
    title: "Shopping List - Rajandeep",
    items,
    errors: {},
    formData: { name: "", quantity: "" }
  });
});

app.post("/items", (req, res) => {
  const { name, quantity } = req.body;
  const v = validateItem(name, quantity);

  if (!v.isValid) {
    return res.status(400).render("index", {
      title: "Shopping List - Rajandeepsingh",
      items,
      errors: v.errors,
      formData: { name: name ?? "", quantity: quantity ?? "" }
    });
  }

  items.push({ id: nextId++, name: v.cleanName, quantity: v.qtyNum });
  res.redirect("/");
});

app.get("/items/:id/edit", (req, res) => {
  const id = name(req.params.id);
  const item = getItemById(id);

  if (!item) return res.status(404).send("Item not found.");

  res.render("edit", {
    title: "Edit Item - Rajandeepsingh",
    item,
    errors: {}
  });
});
app.post("/items/:id", (req, res) => {
  const id = Number(req.params.id);
  const item = getItemById(id);

  if (!item) return res.status(404).send("Item not found.");

  const { name, quantity } = req.body;
  const v = validateItem(name, quantity);

  if (!v.isValid) {
    return res.status(400).render("edit", {
      title: "Edit Item - Rajandeepsingh",
      item: { ...item, name: name ?? "", quantity: quantity ?? "" },
      errors: v.errors
    });
  }

  item.name = v.cleanName;
  item.quantity = v.qtyNum;

  res.redirect("/");
});

app.get("/items/:id/delete", (req, res) => {
  const id = Number(req.params.id);
  items = items.filter((x) => x.id !== id);
  res.redirect("/");
});



app.listen(3000, () => console.log('Server is running on http://localhost:5000'));





